<?php
    // app/Console/Commands/LinkSharingsBackfill.php
    namespace App\Console\Commands;

    use Illuminate\Console\Command;
    use App\Models\User;
    use App\Services\SharingLinker;

    class LinkSharingsBackfill extends Command
    {
        protected $signature = 'sharings:backfill-links {--chunk=500}';
        protected $description = 'Fill sharings.target_user_id based on recipient_email == users.email';

        public function handle(SharingLinker $linker): int
        {
            $chunk = (int)$this->option('chunk');

            $count = 0;
            User::select('id','email')->orderBy('id')->chunk($chunk, function ($users) use ($linker, &$count) {
                foreach ($users as $u) {
                    $count += $linker->linkForUser($u);
                }
            });

            $this->info("Updated rows: {$count}");
            return self::SUCCESS;
        }
    }