<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Register the commands for the application.
     *
     * On y déclare les commandes Artisan personnalisées.
     */
    protected $commands = [
        // ✅ Custom backfill command for linking sharings by email
        \App\Console\Commands\LinkSharingsBackfill::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     */
    protected function schedule(Schedule $schedule): void
    {
        // Exemple : lancer la commande chaque nuit à 2h
        // $schedule->command('sharings:backfill-links')->dailyAt('02:00');

        // Tu peux planifier ici toutes tes tâches périodiques
    }

    /**
     * Register the commands for the application.
     *
     * Cette méthode charge automatiquement toutes les commandes
     * présentes dans app/Console/Commands, en plus du tableau $commands ci-dessus.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}