<?php
    // app/Exceptions/Handler.php

    namespace App\Exceptions;

    use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
    use Illuminate\Auth\AuthenticationException;

    class Handler extends ExceptionHandler
    {
        protected function unauthenticated($request, AuthenticationException $exception)
        {
            if ($request->expectsJson()) {
                return response()->json(['message' => 'Unauthenticated.'], 401);
            }

            return redirect()->guest(
                route('login', ['locale' => app()->getLocale()]) // ← important
                // ou: lr('login')
            );
        }
    }