<?php
   // app/Http/Controllers/Admin/AdminSocietyController.php
 
   namespace App\Http\Controllers\Admin;

   

use App\Http\Controllers\Controller;
use App\Models\Society;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminSocietyController extends Controller
{
    // List with simple search
    public function index(Request $request)
    {
        $q = trim((string)$request->query('q', ''));

        $societies = Society::query()
            ->when($q !== '', fn($qb) => $qb->where('name', 'like', '%'.$q.'%'))
            ->orderBy('name')
            ->paginate(20);

        return view('admin.societies.index', compact('societies', 'q'));
    }






    public function edit(Society $society, ?string $locale = null)
    {
        $society->loadMissing([
            'users:id,firstname,lastname,email,role_id',
            'adminPros:id,firstname,lastname,email,role_id',
            'proUsers:id,firstname,lastname,email,role_id'
        ]);
    
        $adminPros = $society->adminPros;                          // collection
        $adminPro  = $adminPros->first();                          // premier si tu n’en veux qu’un
        $proUsers  = $society->proUsers->sortBy(['lastname','firstname'])->values();
        $currentAdminProId = $society->adminPros()->value('users.id');

        return view('admin.societies.edit', compact('society','adminPros','adminPro','proUsers','currentAdminProId'));


        // $adminPro = $society->users->firstWhere('role_id', 2);
        // $proUsers = $society->users->where('role_id', 4)->sortBy(['lastname','firstname'])->values();
        // $currentAdminProId = $society->adminPros()->value('users.id');

    
        // return view('admin.societies.edit', compact('society','adminPro','proUsers','currentAdminProId'));
    }





    public function update(\Illuminate\Http\Request $request, \App\Models\Society $society)
    {
        $data = $request->validate([
            'name'          => ['required','string','max:255'],
            'street'        => ['nullable','string','max:255'],
            'postcode'      => ['nullable','string','max:50'],
            'city'          => ['nullable','string','max:120'],
            'country'       => ['nullable','string','max:120'],
            'phone'         => ['nullable','string','max:50'],
            'email'         => ['nullable','email','max:255'],
            'subscribed_at' => ['nullable','date'],
            'photo'         => ['nullable','image','max:4096'],
            'remove_photo'  => ['nullable','boolean'],
        ]);

        if (!empty($data['remove_photo'])) {
            if ($society->photo) \Storage::disk('public')->delete($society->photo);
            $data['photo'] = null;
        } else {
            if ($request->hasFile('photo')) {
                if ($society->photo) \Storage::disk('public')->delete($society->photo);
                $data['photo'] = $request->file('photo')->store('societies/photos', 'public');
            } else {
                unset($data['photo']);
            }
        }

        $society->fill($data)->save();

        return back()->with('ok', __('Company updated.'));
    }





    public function destroy(Society $society)
    {
        // Detach users links first to keep pivot clean
        $society->users()->detach();

        $society->delete();

        return redirect()->route('admin.societies.index')->with('ok', __('Society deleted.'));
    }






    /**
     * Assign (or change) the single "admin pro" of a society.
     * Constraints:
     *  - target user must have role_id=2
     *  - an admin pro is linked to ONE society only
     *  - a society has at most ONE admin pro
     */
    public function assignAdminPro(Request $request, Society $society)
    {
        $data = $request->validate([
            'user_id' => ['required','integer','exists:users,id'],
        ]);

        $adminPro = User::where('id', $data['user_id'])->where('role_id', 2)->first();
        if (!$adminPro) {
            return back()->withErrors(['user_id' => __('Selected user is not an Admin Pro (role_id = 2).')]);
        }

        DB::transaction(function () use ($adminPro, $society) {

            // 1) Remove any current admin pro for THIS society (keep only role_id=2)
            $currentAdminIds = $society->adminPro()->pluck('users.id')->all();
            if (!empty($currentAdminIds)) {
                $society->users()->detach($currentAdminIds);
            }

            // 2) Ensure this admin pro is not assigned to any OTHER society
            $otherSocietyIds = DB::table('societydb_user')
                ->where('user_id', $adminPro->id)
                ->where('society_id', '<>', $society->id)
                ->pluck('society_id')->all();

            if (!empty($otherSocietyIds)) {
                DB::table('societydb_user')
                    ->where('user_id', $adminPro->id)
                    ->whereIn('society_id', $otherSocietyIds)
                    ->delete();
            }

            // 3) Attach admin pro to this society (idempotent)
            $society->users()->syncWithoutDetaching([$adminPro->id]);
        });

        return back()->with('ok', __('Admin Pro assigned to the society.'));
    }
}