<?php

    namespace App\Http\Controllers\Admin;

    use App\Http\Controllers\Controller;
    use Illuminate\Http\Request;
    use App\Models\Reporting;
    use Illuminate\Support\Facades\Log;

    class ReportingAdminController extends Controller
    {
        /** List all unresolved reports */
        public function index()
        {
            $reports = Reporting::with('point')
                ->whereNull('resolved')
                ->orderByDesc('created_at')
                ->get();

            return view('admin.reporting.index', compact('reports'));
        }

        /** Show details of one report */
        public function show(Reporting $report)
        {
            return view('admin.reporting.show', compact('report'));
        }

        /** Mark report as resolved (timestamp = now) */
        public function resolve(Reporting $report)
        {
            $report->update(['resolved' => now()]);

            Log::info('reporting:resolved', [
                'id' => $report->id,
                'resolved_at' => $report->resolved,
            ]);

            return redirect()
                ->route('admin.reporting.index')
                ->with('ok', __('Report marked as resolved.'));
        }
    }