<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AuthTokenController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'email'    => ['required','email'],
            'password' => ['required'],
            'device'   => ['nullable','string'],
        ]);

        if (!Auth::attempt($request->only('email','password'))) {
            return response()->json(['message' => 'Invalid credentials'], 422);
        }

        $user  = $request->user();
        $name  = $request->input('device', 'iOS');
        $token = $user->createToken($name)->plainTextToken;

        return response()->json(['token' => $token, 'user' => [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
        ]]);
    }

    public function destroy(Request $request)
    {
        // Revoke the current token
        $request->user()->currentAccessToken()->delete();
        return response()->json(['ok' => true]);
    }
}
