<?php

    namespace App\Http\Controllers\Api;

    use App\Models\Point; // or Waypoint model
    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;
    use App\Http\Resources\WaypointResource;
    use App\Http\Requests\StoreWaypointRequest;
    use App\Http\Requests\UpdateWaypointRequest;

    class WaypointApiController extends Controller
    {


        
        public function index(Request $request)
        {
            // Optional filters/pagination
            $q = Point::query()->orderByDesc('id');

            if ($search = $request->query('q')) {
                $q->where('name', 'like', "%{$search}%");
            }

            return WaypointResource::collection($q->paginate(50));
        }




        public function show(Point $waypoint)
        {
            return new WaypointResource($waypoint);
        }




        public function store(StoreWaypointRequest $request)
        {
            $point = Point::create($request->validated());
            return (new WaypointResource($point))
                ->response()
                ->setStatusCode(201);
        }




        public function update(UpdateWaypointRequest $request, Point $waypoint)
        {
            $waypoint->update($request->validated());
            return new WaypointResource($waypoint);
        }




        public function destroy(Point $waypoint)
        {
            $waypoint->delete();
            return response()->json(['ok' => true]);
        }




        // Toggle the "favorite" flag
        public function toggleFavorite(\App\Models\Point $waypoint)
        {
            $waypoint->favoris = ($waypoint->favoris > 0) ? 0 : 1;
            $waypoint->save();

            return response()->json([
                'id'      => $waypoint->id,
                'favoris' => (int) $waypoint->favoris,
            ]);
        }

    }
