<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use Inertia\Response;
use App\Providers\RouteServiceProvider;


class AuthenticatedSessionController extends Controller
{
    /**
     * Display the login view.
     */
    public function create(): Response
    {
        return \Inertia\Inertia::render('Auth/Login', [
            'canResetPassword' => \Illuminate\Support\Facades\Route::has('password.request'),
            'status' => session('status'),
        ]);
    }







    /**
     * Handle an incoming authentication request.
     */

    public function store(LoginRequest $request)
{
    $request->authenticate();
    $request->session()->regenerate();

    return redirect()->intended(lr('search')); // ✅ intended accepts a URL
}

    // public function store(Request $request)
    // {
    //     $credentials = $request->validate([
    //         'email' => ['required','email'],
    //         'password' => ['required'],
    //     ]);
    
    //     $remember = (bool) $request->boolean('remember');
    
    //     if (! Auth::attempt($credentials, $remember)) {
    //         return back()->withErrors(['email' => 'Identifiants invalides.'])->onlyInput('email');
    //     }
    
    //     $request->session()->regenerate();
    
    //     return redirect(lr('welcome')); // ✅ localized URL

    // }




    
    /**
     * Destroy an authenticated session.
     */
    public function destroy(Request $request): RedirectResponse
    {
        Auth::guard('web')->logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect(lr('welcome')); // ✅ localized URL
    }
}
