<?php
namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Auth;


class LoginController extends Controller
{
        protected function attemptLogin(Request $request)
        {
            $credentials = $this->credentials($request);

            $user = User::where('email', $credentials['email'])->first();
            if ($user && !is_null($user->blocked)) {
                return false; // will fall through to failed response
            }

            return $this->guard()->attempt($credentials, $request->filled('remember'));
        }





        protected function sendFailedLoginResponse(Request $request)
        {
            $user = User::where('email', $request->input('email'))->first();
            if ($user && !is_null($user->blocked)) {
                throw ValidationException::withMessages([
                    'email' => [__('Your account has been blocked. Contact support.')],
                ]);
            }

            throw ValidationException::withMessages([
                $this->username() => [trans('auth.failed')],
            ]);
        }

        protected function guard()
        {
            return Auth::guard();
        }

        protected function username(): string
        {
            return 'email';
        }

        protected function credentials(Request $request): array
        {
            return $request->only($this->username(), 'password');
        }
}
