<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;   // ✅ correct use statement (proper casing)
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password as PasswordRule;
use Inertia\Inertia;

class RegisteredUserController extends Controller
{
    public function create()
    {
        return Inertia::render('Auth/Register');
    }

    
    public function store(Request $request)
    {
        $validated = $request->validate([
            'lastname'         => ['required','string','max:255'],
            'firstname'        => ['required','string','max:255'],
            'email'            => ['required','string','email','max:255','unique:users,email'],
            'phone'            => ['nullable','string','max:50'],
            'address1'         => ['nullable','string','max:255'],
            'address2'         => ['nullable','string','max:255'],
            'postcode'         => ['nullable','string','max:40'],
            'city'             => ['nullable','string','max:120'],
            'country_isocode'  => ['nullable','string','max:3'], // column is VARCHAR(3)
            'password'         => ['required','confirmed', PasswordRule::defaults()],
        ]);
    
        // Build a "name" value to satisfy the NOT NULL constraint
       $name = trim(($validated['firstname'] ?? '') ?: strtolower($validated['email']));

        $user = User::create([
            'role_id'          => 3, // default role
            'lastname'         => $validated['lastname'],
            'firstname'        => $validated['firstname'],
            'name'             => $name, // ✅ important
            'email'            => strtolower($validated['email']),
            'phone'            => $validated['phone'] ?? null,
            'address1'         => $validated['address1'] ?? null,
            'address2'         => $validated['address2'] ?? null,
            'postcode'         => $validated['postcode'] ?? null,
            'city'             => $validated['city'] ?? null,
            'country_isocode'  => $validated['country_isocode'] ?? null,
            'password'         => Hash::make($validated['password']),
        ]);
    
        auth()->login($user);
        return redirect()->route('welcome', ['locale' => app()->getLocale()])->with('status','Compte créé. Bienvenue !');
    }

}
