<?php

    // app/Http/Controllers/Auth/VerificationNoticeController.php
    namespace App\Http\Controllers\Auth;

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Log;
    use App\Http\Controllers\Controller;

    class VerificationNoticeController extends Controller
    {
        public function send(Request $request)
        {
            $user = $request->user();
            if (!$user) {
                return redirect()->route('login', ['locale' => app()->getLocale()]);
            }

            if ($user->hasVerifiedEmail()) {
                return back()->with('ok', __('Email already verified.'));
            }

            try {
                $user->sendEmailVerificationNotification();
                return back()->with('ok', __('Verification email resent.'));
            } catch (\Throwable $e) {
                Log::error('verification.send failed', ['user_id' => $user->id, 'e' => $e->getMessage()]);
                return back()->with('error', __('Unable to send verification email right now.'));
            }
        }
    }