<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactMessage;
use Illuminate\Support\Facades\Log;
use App\Mail\TestBrevoMail;

class ContactController extends Controller
{
    public function send(Request $request)
    {
        $data = $request->validate([
            'name'    => 'required|string|max:255',
            'email'   => 'required|email',
            'message' => 'required|string|max:5000',
        ]);
    
        Mail::send('emails.contact', ['data' => $data], function ($m) use ($data) {
            $m->to('contact@tondomaine.fr', 'Vereego')
              ->replyTo($data['email'], $data['name'])
              ->subject('Nouveau message du site');
        });
    
        return back()->with('ok', __('Message sent!'));
    }





    public function sendContact(Request $request)
    {
        $data = $request->validate([
            'name'    => 'required|string|max:255',
            'email'   => 'required|email',
            'message' => 'required|string|max:5000',
        ]);

        // Mail::to(config('mail.from.address'))
        //     ->send(new ContactMessage($data));

        Mail::raw('Test Brevo OK', function($m){
            $m->to('toi@exemple.com')->subject('Test SMTP Brevo');
        });

        return back()->with('ok', 'Message envoyé ✅');
    }


}