<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\Point;

class CoordonneesController extends Controller
{

    public function register_new_coordonnes(Request $request)
    {
        $message = "Coordonnées enregistrées";

        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'latitude' => 'required|numeric|between:-90,90',
            'longitude' => 'required|numeric|between:-180,180',
        ]);

        if ($validator->fails()) {
            return redirect('/register')
                ->withErrors($validator)
                ->withInput();
        }

        $point = Point::create([
            'name' => $request->name,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude
        ]);

        return view('register', compact('message'));
    }

    public function searchWP_index()
    {
        $coord = Point::all();
        return view('searchWP', compact('coord'));
    }

    public function resultWP(Request $request)
    {
        $name = $request->name;
        $coord = Point::where('name', $name)->first();

        if (!$coord) {
            $message = "Aucunes coordonnées trouvées pour le nom : " . $name;
            return view('searchWP', compact('message'));
        }

        $message = "Coordonnées trouvées : " . $name . " (Latitude: " . $coord->latitude . ", Longitude: " . $coord->longitude . ")";
        return view('searchWP', compact('message'));
    }

    public function displayMap_index()
    {
        $points = Point::all();
        return view('map', compact('points'));
    }
}