<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\ItinerarySyncer;

class ItineraryPointsUserController extends Controller
{
    public function store(Request $request, ?string $locale = null)
    {
        // … validation, création $itinerary …

        // 1) points (gabarit)
        $pointIds = $request->input('point_ids', []); // duplicates allowed si tu veux, sinon array_unique
        $attach = [];
        foreach ($pointIds as $i => $pid) {
            $attach[$pid] = ['sort_order' => $i+1]; // + autres champs de gabarit si tu les sais ici
        }
        $itinerary->templateItems()->sync($attach);

        // 2) assign users
        $userIds = $request->input('assigned_user_ids', []);
        $itinerary->assignedUsers()->sync($userIds);

        // 3) backfill vers itinerary_points_user
        app(ItinerarySyncer::class)->syncUsers($itinerary, $userIds);

        // …
    }




    
    public function update(Request $request, Itinerary $itinerary, ?string $locale = null)
    {
        // … validation + update de base …

        // points gabarit
        $pointIds = $request->input('point_ids', []);
        $attach = [];
        foreach ($pointIds as $i => $pid) {
            $attach[$pid] = ['sort_order' => $i+1];
        }
        $itinerary->templateItems()->sync($attach);

        // users
        $userIds = $request->input('assigned_user_ids', []);
        $itinerary->assignedUsers()->sync($userIds);

        // sync manquants pour tous les users assignés
        app(ItinerarySyncer::class)->syncUsers($itinerary, $userIds);

        // …
    }





    public function saveProgress(Request $request, string $locale, \App\Models\Itinerary $itinerary)
    {
        $user = $request->user();

        // Who are we updating for?
        $targetUserId = (int)($request->input('target_user_id') ?: $user->id);

        // Authorization simple: super admin, owner, manager, admin pro of same society, or the user himself
        $isSuper   = (int)$user->id === 1;
        $isOwner   = (int)$itinerary->owner_user_id === (int)$user->id;
        $isManager = (int)$itinerary->assigned_user_id === (int)$user->id;
        $isProSame = (int)($user->role_id ?? 0) === 2
            && $user->societies()->where('society_id',$itinerary->society_id)->exists();
        $isSelf    = (int)$user->id === $targetUserId;

        if (!($isSuper||$isOwner||$isManager||$isProSame||$isSelf)) {
            abort(403);
        }

        $data = $request->validate([
            'items'                  => ['array'],
            'items.*.done'           => ['nullable','boolean'],
            'items.*.planned_at'     => ['nullable','date'],
            'items.*.arrival_at'     => ['nullable','date'],
            'items.*.validated_at'   => ['nullable','date'],
            'items.*.rescheduled_at' => ['nullable','date'],
            'items.*.comment'        => ['nullable','string'],
        ]);

        $rows = $data['items'] ?? [];
        foreach ($rows as $itemId => $fields) {
            $ipu = \App\Models\ItineraryPointUser::where('id', $itemId)
                ->where('itinerary_id', $itinerary->id)
                ->where('user_id', $targetUserId)
                ->first();

            if (!$ipu) {
                // sécurité: ignore ce qui n’appartient pas à l’itinéraire+user cible
                continue;
            }

            // apply changes
            if (array_key_exists('done',$fields))           $ipu->done = (bool)$fields['done'];
            if (array_key_exists('planned_at',$fields))     $ipu->planned_at = $fields['planned_at'] ?: null;
            if (array_key_exists('arrival_at',$fields))     $ipu->arrival_at = $fields['arrival_at'] ?: null;
            if (array_key_exists('validated_at',$fields))   $ipu->validated_at = $fields['validated_at'] ?: null;
            if (array_key_exists('rescheduled_at',$fields)) $ipu->rescheduled_at = $fields['rescheduled_at'] ?: null;
            if (array_key_exists('comment',$fields))        $ipu->comment = $fields['comment'] ?? null;

            $ipu->save();
        }

        return $request->expectsJson()
            ? response()->json(['ok'=>true])
            : back()->with('ok', __('Progress saved.'));
    }
}
