<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Itinerary;

class MyItinerariesController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }




    public function index(\Illuminate\Http\Request $request, ?string $locale = null)
    {
        $user = $request->user();
    
        $itineraries = $user->itinerariesAssigned()
            ->with([
                'society:id,name',
                'owner:id,firstname,lastname',
            ])
            ->with([
                // Charge les items personnalisés (table itinerary_points_user) pour CE user
                'itemsUser' => function ($q) use ($user) {
                    $q->where('user_id', $user->id)
                      ->orderBy('sort_order')
                      ->with('point:id,name,city');
                },
            ])
            ->orderByDesc('created_at')
            ->get();
    
        return view('itins.mine', ['itins' => $itineraries, 'user' => $user]);
    }



    public function scopeWithItemsForUser($query, $userId)
    {
        return $query->with(['itemsUser' => fn($q) => $q->where('user_id', $userId)->with('point:id,name,city')]);
    }




}