<?php
    // app/Http/Controllers/Pro/ProPointController.php
    namespace App\Http\Controllers\Pro;

    use App\Http\Controllers\Controller;
    use Illuminate\Http\Request;
    use App\Models\Point;
    use App\Support\ProSociety;

    class ProPointController extends Controller
    {
        public function index(Request $request, string $locale)
        {
            $me = $request->user();
            $socId = ProSociety::currentSocietyId($me);
            abort_if(!$socId, 403);

            // Example: points owned by users of the society OR shared to them.
            // If you have a scope visibleForCompany($socId), prefer it.
            $userIds = $me->societies()
                ->where('society_id', $socId)
                ->first()
                ?->users()
                ->pluck('users.id') ?? collect();

            $points = Point::query()
                ->whereIn('user_id', $userIds)   // owned by company users
                ->orderByDesc('created_at')
                ->paginate(20);

            return view('pro.points.index', compact('points'));
        }
    }