<?php
    // app/Http/Controllers/ReportingController.php
    namespace App\Http\Controllers;

    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Log;
    use App\Models\Reporting;
    use App\Models\Point;

    class ReportingController extends Controller
    {
        /** Public endpoint to create a report (read-only page) */
        public function store(Request $request)
        {
            // Validate
            $data = $request->validate([
                'point_id' => ['required','integer','exists:points,id'],
                'email'    => ['nullable','email','max:255'],
                'message'  => ['required','string','max:2000'],
            ]);

            // Double-check the point exists (and you can add extra rules if needed)
            $point = Point::findOrFail((int)$data['point_id']);

            // Create record
            $report = Reporting::create([
                'point_id' => $point->id,
                'email'    => $data['email'] ?? null,
                'message'  => $data['message'],
                'resolved' => null,
            ]);

            Log::info('reporting:created', [
                'report_id' => $report->id,
                'point_id'  => $point->id,
                'ip'        => $request->ip(),
                'ua'        => substr((string)$request->userAgent(), 0, 255),
            ]);

            // Redirect back to the same page with a flash message
            return back()->with('ok', __('Your report has been submitted. Thank you!'));
        }


    }