<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactMessage;

class WelcomeController extends Controller
{
    public function sendContact(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'message' => 'required|string|min:10',
        ]);

        $to = $validated['email'];
        Mail::to('studio@labourel.com')->send(new ContactMessage($validated));

        return back()->with('ok', 'Votre message a bien été envoyé !');
    }
}