<?php


    namespace App\Http;

    use Illuminate\Foundation\Http\Kernel as HttpKernel;

    class Kernel extends HttpKernel
    {

        protected $middleware = [
            // ...
            \App\Http\Middleware\SetLocale::class, 
        ];


        protected $middlewareAliases = [
            // ... alias existants ...
            'auth' => \App\Http\Middleware\Authenticate::class,
            // ...
            'superadmin' => \App\Http\Middleware\EnsureUserIsSuperAdmin::class,

            'set.locale' => \App\Http\Middleware\SetLocale::class,
        ];



        protected $middlewareGroups = [
            'web' => [
                \Illuminate\Cookie\Middleware\EncryptCookies::class,
                \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
                \Illuminate\Session\Middleware\StartSession::class,

                \App\Http\Middleware\SetLocale::class,     // (celui qui lit {locale} / ?locale=)
                \App\Http\Middleware\InjectLocaleIntoUrl::class, // 👈 ajoute celui-ci APRES SetLocale
                \App\Http\Middleware\EnsureUserNotBlocked::class, // add here to check on each web request
                \App\Http\Middleware\LocaleUrlDefaults::class, // (optionnel, si besoin de forcer les URLs générées)

                \Illuminate\View\Middleware\ShareErrorsFromSession::class,
                \Illuminate\Foundation\Http\Middleware\ValidateCsrfToken::class,
                \Illuminate\Routing\Middleware\SubstituteBindings::class,
                
              ],
         ];



        protected $routeMiddleware = [
            // ...
            'set.locale'    => \App\Http\Middleware\SetLocale::class,
            'inject.locale' => \App\Http\Middleware\InjectLocaleIntoUrl::class,
            'admin.pro'     => \App\Http\Middleware\EnsureAdminPro::class

        ];


    }