<?php

    // app/Http/Middleware/EnsureAdminPro.php
    namespace App\Http\Middleware;

    use Closure;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Auth;

    class EnsureAdminPro
    {
        public function handle(Request $request, Closure $next)
        {
            $u = $request->user();

            // Must be authenticated, role == 2 (Admin Pro), and not blocked
            if (!$u || (int)$u->role_id !== 2 || !is_null($u->blocked)) {
                abort(403);
            }

            return $next($request);
        }
    }