<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureUserIsSuperAdmin
{
    public function handle(Request $request, Closure $next)
    {
        // If not authenticated → redirect to /{locale}/login
        if (!Auth::check()) {
            $locale = $request->route('locale') ?? app()->getLocale() ?? 'fr';
            return redirect("/{$locale}/login");
        }

        $user = Auth::user();

        // Adjust this to your role model:
        $isSuper =
            ((int)($user->role_id ?? 0) === 1)
            || strcasecmp(optional($user->role)->name ?? '', 'Super administrateur') === 0;

        if (!$isSuper) {
            // Access denied
            abort(403, 'Forbidden');
        }

        return $next($request);
    }
}
