<?php

    // app/Http/Middleware/EnsureUserNotBlocked.php
    namespace App\Http\Middleware;

    use Closure;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Auth;

    class EnsureUserNotBlocked
    {
        public function handle(Request $request, Closure $next)
        {
            $u = $request->user();
            if ($u && !is_null($u->blocked)) {
                Auth::logout();
                $request->session()->invalidate();
                $request->session()->regenerateToken();
                return redirect()->route('login', ['locale' => app()->getLocale()])->withErrors([
                    'email' => __('Your account has been blocked. Contact support.'),
                ]);
            }
            return $next($request);
        }
    }   