<?php

namespace App\Http\Middleware;

use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     */
    protected $rootView = 'app'; // ou 'welcome' selon ton setup

    /**
     * Determine the current asset version.
     */
    public function version($request): ?string
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     */
    public function share($request): array
    {
        return array_merge(parent::share($request), [
            'auth' => [
                'user' => fn () => $request->user()?->only('id','name','email'),
            ],
            // Ne pas instancier Ziggy si absent
            'ziggy' => fn () => class_exists(\Tightenco\Ziggy\Ziggy::class)
                ? (new \Tightenco\Ziggy\Ziggy)->toArray()
                : null,
        ]);
    }
}