<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\URL;

class LocaleUrlDefaults
{
    public function handle($request, Closure $next)
    {
        // valeur choisie dans cet ordre : paramètre d’URL, session, app locale, fallback fr
        $locale = $request->route('locale')
            ?? session('locale')
            ?? app()->getLocale()
            ?? 'fr';

        // verrouille sur la whitelist si tu veux
        $supported = config('locales.supported', ['fr','en','es']);
        if (!in_array($locale, $supported, true)) {
            $locale = config('app.locale', 'fr');
        }

        // applique la valeur par défaut pour la génération d’URL (route(), url())
        URL::defaults(['locale' => $locale]);

        return $next($request);
    }
}