<?php
    // app/Http/Middleware/RedirectIfAuthenticated.php
    namespace App\Http\Middleware;

    use Illuminate\Support\Facades\Auth;


    class RedirectIfAuthenticated extends Middleware
    {
        public function handle($request, \Closure $next, ...$guards)
        {
            foreach ($guards as $guard) {
                if (Auth::guard($guard)->check()) {
                    return redirect()->route('search', ['locale' => app()->getLocale()]);
                    // ou: return redirect(lr('search'));
                }
            }

            return $next($request);
        }
    }