<?php

    // app/Http/Middleware/SetLocale.php
    namespace App\Http\Middleware;

    use Closure;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\App;
    use Illuminate\Support\Facades\URL;
    use Illuminate\Support\Arr;

    class SetLocale
    {
        public function handle(Request $request, Closure $next)
        {

            $supported   = array_keys(config('locales.supported'));
            $detectable  = config('locales.detectable');
            $default     = config('locales.default', config('app.locale', 'fr'));

            $param = $request->route('locale');                 // /{locale}
            $sessionLocale = $request->session()->get('locale');
            $browser = $request->getPreferredLanguage($detectable);

            $locale = $param ?: $sessionLocale ?: $browser ?: $default;
            if (! in_array($locale, $supported, true)) {
                $locale = $default;
            }

            app()->setLocale($locale);
            $request->setLocale($locale);
            $request->session()->put('locale', $locale);

            URL::defaults(['locale' => $locale]);

            return $next($request);
        }






        private function normalizeSupportedLocales($config): array
        {

            $supported   = array_keys(config('locales.supported'));
            $detectable  = config('locales.detectable');
            $default     = config('locales.default', config('app.locale', 'fr'));
            
            $param = $request->route('locale');                 // /{locale}
            $sessionLocale = $request->session()->get('locale');
            $browser = $request->getPreferredLanguage($detectable);
            
            $locale = $param ?: $sessionLocale ?: $browser ?: $default;
            if (! in_array($locale, $supported, true)) {
                $locale = $default;
            }
            
            app()->setLocale($locale);
            $request->setLocale($locale);
            $request->session()->put('locale', $locale);
            


            // if (!is_array($config)) {
            //     return ['fr','en','es','kr'];
            // }

            // $locales = [];

            // if (array_is_list($config)) {
            //     foreach ($config as $value) {
            //         if (is_string($value) && $value !== '') {
            //             $locales[] = $value;
            //         } elseif (is_array($value) && isset($value['code']) && is_string($value['code'])) {
            //             $locales[] = $value['code'];
            //         }
            //     }
            // } else {
            //     foreach ($config as $key => $value) {
            //         if (is_string($key) && $key !== '') {
            //             $locales[] = $key;
            //         } elseif (is_array($value) && isset($value['code']) && is_string($value['code'])) {
            //             $locales[] = $value['code'];
            //         }
            //     }
            // }

            // if (empty($locales)) {
            //     $locales = ['fr','en','es','kr'];
            // }

            return array_values(array_unique($locales));
        }
    }
