<?php

    namespace App\Http\Requests;

    use Illuminate\Foundation\Http\FormRequest;

    class StoreWaypointRequest extends FormRequest
    {
        public function authorize(): bool { return true; } // or add your authorization rules

        public function rules(): array
        {
            return [
                'name'      => ['required','string','max:255'],
                'latitude'  => ['required','numeric','between:-90,90'],
                'longitude' => ['required','numeric','between:-180,180'],
                'altitude'  => ['nullable','numeric'],
                'address'   => ['nullable','string','max:500'],
                'notes'     => ['nullable','string'],
            ];
        }
    }
