<?php

    namespace App\Http\Requests;

    use Illuminate\Foundation\Http\FormRequest;

    class UpdateWaypointRequest extends FormRequest
    {
        public function authorize(): bool { return true; }

        public function rules(): array
        {
            return [
                'name'      => ['sometimes','string','max:255'],
                'latitude'  => ['sometimes','numeric','between:-90,90'],
                'longitude' => ['sometimes','numeric','between:-180,180'],
                'altitude'  => ['nullable','numeric'],
                'address'   => ['nullable','string','max:500'],
                'notes'     => ['nullable','string'],
            ];
        }
    }