<?php

    namespace App\Http\Resources;

    use Illuminate\Http\Request;
    use Illuminate\Http\Resources\Json\JsonResource;

    class WaypointResource extends JsonResource
    {
        public function toArray($request)
        {
            return [
                'id'        => $this->id,
                'name'      => $this->name,
                'latitude'  => (float) $this->latitude,
                'longitude' => (float) $this->longitude,
                'altitude'  => $this->altitude !== null ? (float) $this->altitude : null,
                'address'   => $this->address,
                'notes'     => $this->notes,
                'created_at'=> $this->created_at?->toISOString(),
                'updated_at'=> $this->updated_at?->toISOString(),
            ];
        }
    }