<?php

    // app/Jobs/LinkSharingsToUser.php
    namespace App\Jobs;

    use App\Models\User;
    use App\Services\SharingLinker;
    use Illuminate\Bus\Queueable;
    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Foundation\Bus\Dispatchable;
    use Illuminate\Queue\InteractsWithQueue;
    use Illuminate\Queue\SerializesModels;

    class LinkSharingsToUser implements ShouldQueue
    {
        use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

        public function __construct(public int $userId) {}

        public function handle(SharingLinker $linker): void
        {
            $user = User::find($this->userId);
            // Service now accepts null, but still bail fast if not found
            if (!$user) return;

            $linker->linkForUser($user);
        }
    }