<?php

namespace App\Listeners;

use App\Models\UserConnection;
use Illuminate\Auth\Events\Logout;

class LogUserDisconnection
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(Logout $event): void
    {
        // Retrieve the most recent open session
        $lastConnection = UserConnection::where('user_id', $event->user->id)
            ->whereNull('disconnected_at')
            ->latest('connected_at')
            ->first();

        if ($lastConnection) {
            $now = now();

            $lastConnection->update([
                'disconnected_at' => $now,
                'time_connected' => $lastConnection->connected_at
                    ? $lastConnection->connected_at->diffInSeconds($now)
                    : null,
            ]);
        }
    }
}
