<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EmailChangeCodeMail extends Mailable
{
    use Queueable, SerializesModels;

    public string $code;
    public string $newEmail;

    public function __construct(string $code, string $newEmail)
    {
        $this->code = $code;
        $this->newEmail = $newEmail;
    }

    public function build()
    {
        return $this->from(config('mail.from.address'), config('mail.from.name'))
            ->subject(__('Verify your new email'))
            ->markdown('emails.users.email_change_code', [
                'code'     => $this->code,
                'newEmail' => $this->newEmail,
            ]);
    }
}