<?php

// app/Mail/PointSharedMail.php
namespace App\Mail;

use App\Models\Point;
use App\Models\User;
use App\Models\Sharing;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PointSharedMail extends Mailable
{
    use Queueable, SerializesModels;

    public Point $point;
    public ?User $owner;
    public ?Sharing $sharing;
    public string $recipientEmail;
    public ?User $recipientUser;

    public function __construct(Point $point, ?User $owner, string $recipientEmail, ?Sharing $sharing = null, ?User $recipientUser = null)
    {
        $this->point          = $point;
        $this->owner          = $owner;
        $this->recipientEmail = $recipientEmail;
        $this->sharing        = $sharing;
        $this->recipientUser  = $recipientUser;
    }

    public function build()
    {
        // Build safe strings for the view (no object property reads in Blade)
        $ownerName = $this->owner
            ? trim(($this->owner->firstname ?? '') . ' ' . ($this->owner->lastname ?? '')) ?: ($this->owner->name ?? $this->owner->email)
            : __('Someone');

        $ownerEmail = $this->owner?->email ?? null;

        $recipientName = $this->recipientUser
            ? trim(($this->recipientUser->firstname ?? '') . ' ' . ($this->recipientUser->lastname ?? '')) ?: ($this->recipientUser->name ?? $this->recipientEmail)
            : null;

        // Public read-only URL
        $locale = app()->getLocale();
        $token  = $this->point->serial;
        $url    = route('points.public.readonly', ['locale' => $locale, 'token' => $token], true);

        return $this->subject(__('A waypoint has been shared with you'))
            ->view('emails.points.share')
            ->with([
                'point'          => $this->point,
                'url'            => $url,
                'ownerName'      => $ownerName,
                'ownerEmail'     => $ownerEmail,
                'recipientEmail' => $this->recipientEmail,
                'recipientName'  => $recipientName,
                'sharing'        => $this->sharing,
            ]);
    }
}