<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class TestBrevoMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public ?string $messageText = null
    ) {}

    public function envelope(): Envelope
    {
        return new Envelope(subject: 'Test Brevo OK');
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.test',
            with: ['messageText' => $this->messageText ?? 'Ceci est un mail de test'],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}