<?php
    // app/Models/ItineraryPoint.php
    namespace App\Models;

    use Illuminate\Database\Eloquent\Model;

    class ItineraryPoint extends Model
    {
        protected $table    = 'itinerary_points';
        protected $fillable = [
            'itinerary_id',
            'point_id',
            'sort_order',
            'planned_at',
            'arrival_at',
            'done',            // keep if you still display a boolean status
            'validated_at',
            'rescheduled_at',
            'comment',
        ];

        protected $casts = [
            'planned_at'     => 'datetime',
            'arrival_at'     => 'datetime',
            'validated_at'   => 'datetime',
            'rescheduled_at' => 'datetime',
            'done'           => 'boolean',
        ];

        public function itinerary(){ return $this->belongsTo(Itinerary::class); }
        public function point()    { return $this->belongsTo(Point::class, 'point_id'); }
    }