<?php
    // app/Models/ItineraryPointUser.php
    namespace App\Models;

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;

    class ItineraryPointUser extends Model
    {
        protected $table = 'itinerary_points_user';
        protected $fillable = [
            'itinerary_id','point_id','user_id',
            'sort_order','planned_at','arrival_at','done',
            'validated_at','rescheduled_at','comment',
        ];
        protected $casts = [
            'done' => 'boolean',
            'planned_at' => 'datetime',
            'arrival_at' => 'datetime',
            'validated_at' => 'datetime',
            'rescheduled_at' => 'datetime',
        ];

        public function itinerary(): BelongsTo { return $this->belongsTo(Itinerary::class); }
        
        public function point()
        {
            return $this->belongsTo(Point::class, 'point_id');
        }

        public function user(): BelongsTo { return $this->belongsTo(User::class); }
    }