<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sharing extends Model
{
    protected $table = 'sharingdb';

     protected $fillable = [
        'owner_user_id',
        'point_id',
        'target_user_id',   // may be null for external emails
        'recipient_email',  // external email address
        'start_at',
        'end_at',
    ];

    protected $casts = [
        'start_at' => 'datetime',
        'end_at'   => 'datetime',
    ];

    public function point()
    {
        return $this->belongsTo(Point::class);
    }

    public function owner()
    {
        return $this->belongsTo(User::class, 'owner_user_id');
    }

    public function target()
    {
        return $this->belongsTo(User::class, 'target_user_id');
    }
}