<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Society extends Model
{
    protected $table = 'societydb';     // table name
    protected $primaryKey = 'id';
    public $timestamps = true;         // set to true if you have created_at/updated_at

    protected $fillable = [
        'name','street','postcode','city','country','phone','email','subscribed_at','photo',
    ];
 
    


    public function users()
    {
        return $this->belongsToMany(
            \App\Models\User::class,
            'societydb_user',
            'society_id',
            'user_id'
        )->withTimestamps();
    } 




    /** Convenience: only Pro users (role_id=4) */
    public function proUsers()
    {
        return $this->users()->where('users.role_id', 4);
    }



    /** Current admin pro (0..1) resolved dynamically by role_id = 2 */
    public function adminPros()
    {
        return $this->users()->where('users.role_id', 2);
    }

    public function proAdmins()
    {
        return $this->users()->where('role_id', 2);
    }


}