<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserConnection extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'connected_at',
        'disconnected_at',
        'time_connected',
    ];

    protected $casts = [
        'connected_at' => 'datetime',
        'disconnected_at' => 'datetime',
        'time_connected' => 'integer',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
