<?php

    namespace App\Observers;

    use App\Models\User;
    use App\Services\SharingLinker;

    class UserObserver
    {
        public function created(User $user): void
        {
            app(SharingLinker::class)->linkForUser($user);
        }

        public function updated(User $user): void
        {
            if ($user->wasChanged('email')) {
                app(SharingLinker::class)->linkForUser($user);
            }
        }
    }