<?php
    // app/Policies/ItineraryPolicy.php
    namespace App\Policies;

    use App\Models\User;
    use App\Models\Itinerary;

    class ItineraryPolicy
    {
        public function viewAny(User $user): bool
        {
            return $user->id === 1 || $user->hasRoleId(2); // 1 = super admin, 2 = admin pro
        }

        public function view(User $user, Itinerary $it): bool
        {
            if ($user->id === 1) return true;
            // Admin Pro: même société
            return (int)$it->society_id === (int)$user->societies()->value('society_id');
        }

        public function create(User $user): bool
        {
            return $this->viewAny($user);
        }

        public function update(User $user, Itinerary $it): bool
        {
            return $this->view($user, $it);
        }

        public function delete(User $user, Itinerary $it): bool
        {
            return $this->view($user, $it);
        }
    }