<?php

namespace App\Providers;

use Illuminate\Support\Facades\Vite;
use Illuminate\Support\ServiceProvider;
use App\Models\User;
use App\Observers\UserObserver;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\App;

class AppServiceProvider extends ServiceProvider
{
    protected $policies = [
        \App\Models\Point::class => \App\Policies\PointPolicy::class,
    ];
    
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Vite::prefetch(concurrency: 3);
        User::observe(UserObserver::class);

        // Fallback si SetLocale n’a pas encore exécuté

        View::share('locales', config('locales.supported'));

        // $locale = request()->route('locale')
        //     ?? session('locale')
        //     ?? 'fr';
        // $locale = str_starts_with(strtolower((string)$locale), 'en') ? 'en' : 'fr';
    
        //URL::defaults(['locale' => $locale]);
    }
    
}
