<?php
    namespace App\Providers;

    use App\Models\Point;
    use App\Models\User;
    use Illuminate\Support\Facades\Route;
    use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;


    class RouteServiceProvider extends ServiceProvider
    {
        public const HOME = '/';   // 👈 define the post-login home route here
 
        public function boot(): void
        {
            parent::boot();
    
            Route::model('user', User::class);
    
            Route::bind('point', function ($value) {
                return Point::where('serial', $value)
                    ->orWhere('id', ctype_digit($value) ? (int)$value : 0)
                    ->firstOrFail();
            });
        }
    
    
    }
