<?php
    // app/Services/ItinerarySyncer.php
    namespace App\Services;

    use App\Models\Itinerary;
    use App\Models\ItineraryPointUser;
    use Illuminate\Support\Facades\DB;

    class ItinerarySyncer
    {
        // Copy defaults from itinerary_points to itinerary_points_user for given users
        public function syncUsers(Itinerary $itinerary, array $userIds): void
        {
            $template = $itinerary->templateItems()->get()->map(function($p){
                return [
                    'point_id'       => $p->id,
                    'sort_order'     => (int)($p->pivot->sort_order ?? 0),
                    'planned_at'     => $p->pivot->planned_at,
                    'arrival_at'     => $p->pivot->arrival_at,
                    'done'           => (bool)($p->pivot->done ?? false),
                    'validated_at'   => $p->pivot->validated_at,
                    'rescheduled_at' => $p->pivot->rescheduled_at,
                    'comment'        => $p->pivot->comment,
                ];
            });

            DB::transaction(function () use ($itinerary, $userIds, $template) {
                foreach ($userIds as $uid) {
                    foreach ($template as $row) {
                        ItineraryPointUser::firstOrCreate(
                            [
                                'itinerary_id' => $itinerary->id,
                                'point_id'     => $row['point_id'],
                                'user_id'      => $uid,
                            ],
                            [
                                'sort_order'     => $row['sort_order'],
                                'planned_at'     => $row['planned_at'],
                                'arrival_at'     => $row['arrival_at'],
                                'done'           => $row['done'],
                                'validated_at'   => $row['validated_at'],
                                'rescheduled_at' => $row['rescheduled_at'],
                                'comment'        => $row['comment'],
                            ]
                        );
                    }
                }
            });
        }

        // When template points change, propagate to existing users (only create missing, don't overwrite user changes)
        public function syncPoints(Itinerary $itinerary): void
        {
            $userIds = $itinerary->assignedUsers()->pluck('users.id')->all();
            if (empty($userIds)) return;
            $this->syncUsers($itinerary, $userIds);
        }
    }