<?php

    // app/Services/SharingLinker.php
    namespace App\Services;

    use Illuminate\Support\Facades\DB;
    use App\Models\User;

    class SharingLinker
    {
        /**
         * Link sharings whose recipient_email equals the user's email.
         * Accepts null gracefully (returns 0).
         */
        public function linkForUser(?User $user): int
        {
            // Guard: null or missing essentials
            if (!$user || !$user->id || !is_string($user->email) || $user->email === '') {
                return 0;
            }

            $email = strtolower(trim($user->email));
            if ($email === '') {
                return 0;
            }

            // Use your real table name
            return DB::table('sharingdb')
                ->whereNull('target_user_id')
                ->whereRaw('LOWER(recipient_email) = ?', [$email])
                ->update([
                    'target_user_id' => $user->id,
                    'updated_at'     => now(),
                ]);
        }
    }