<?php
    // app/Support/Serial.php
    namespace App\Support;

    use App\Models\Point;

    class Serial
    {
        public static function ensure(Point $p): void
        {
            if (!empty($p->serial)) return;

            $date  = $p->created_at ? $p->created_at->format('Y-m-d') : now()->format('Y-m-d');
            $rand6 = random_int(100000, 999999);
            $raw   = "{$p->id}-{$date}-{$rand6}";

            $p->serial = rtrim(strtr(base64_encode($raw), '+/', '-_'), '=');
            $p->save();
        }
    }