<?php

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;


if (!function_exists('lr')) {
    /**
     * Generate a localized route (prefix-based, e.g. /fr/login)
     */
    function lr(string $name, array $params = [], bool $absolute = true): string
    {
        $locale = app()->getLocale();

        // Ensure 'locale' is the first route parameter
        $params = array_merge(['locale' => $locale], $params);

        return route($name, $params, $absolute);
    }
    
}




if (!function_exists('lr_url')) {
    /**
     * Build an absolute URL from a localized path, e.g. lr_url('/search')
     */
    function lr_url(string $path = ''): string
    {
        $loc = app()->getLocale() ?? 'fr';
        $path = ltrim($path, '/');
        return url("/{$loc}/{$path}");
    }
}



    /**
     * Format a date according to the current locale's date format
     */

function localized_date(?Carbon $date, string $formatKey = 'date_format'): string
{
    if (!$date) return '—';

    $locale = app()->getLocale();
    $fmt = config("locales.supported.$locale.$formatKey", 'd/m/Y');

    return $date->locale($locale)->translatedFormat($fmt);
}