<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('points', function (Blueprint $table) {
            $table->string('address1')->nullable()->after('comment');
            $table->string('address2')->nullable()->after('address1');
            $table->string('postcode', 32)->nullable()->after('address2');
            $table->string('city', 120)->nullable()->after('postcode');
            $table->string('country_isocode', 3)->nullable()->after('city'); // ex: 'FR'
            $table->string('photo')->nullable()->after('country_isocode');   // chemin du fichier
            $table->string('qrcode')->nullable()->after('photo');            // chemin du QR
        });
    }

    public function down(): void {
        Schema::table('points', function (Blueprint $table) {
            $table->dropColumn(['address1','address2','postcode','city','country_isocode','photo','qrcode']);
        });
    }
};