<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('users', function (Blueprint $table) {
            $table->string('lastname')->nullable()->after('id');
            $table->string('firstname')->nullable()->after('lastname');
            $table->string('phone')->nullable()->after('email');
            $table->string('address1')->nullable()->after('phone');
            $table->string('address2')->nullable()->after('address1');
            $table->string('postcode')->nullable()->after('address2');
            $table->string('city')->nullable()->after('postcode');
            $table->string('country_isocode', 3)->nullable()->after('city');
            // Breeze a déjà email, email_verified_at, password
            // email est unique & not null par défaut
        });
    }

    public function down(): void {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'lastname','firstname','phone','address1','address2',
                'postcode','city','country_isocode',
            ]);
        });
    }
};