<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('roledb', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // ex: "Super administrateur"
            $table->timestamps();
        });

        // ⚡ insérer les rôles par défaut
        DB::table('roledb')->insert([
            ['name' => 'Super administrateur', 'created_at'=>now(), 'updated_at'=>now()],
            ['name' => 'Administrateur local', 'created_at'=>now(), 'updated_at'=>now()],
            ['name' => 'Private',              'created_at'=>now(), 'updated_at'=>now()],
            ['name' => 'Distributer',          'created_at'=>now(), 'updated_at'=>now()],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('roledb');
    }
};